using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Class DlgSchedulePrint
	/// </summary>
	public class DlgSchedulePrint : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.TextBox txtReportName;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox grpLine;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="reportName"></param>
		public DlgSchedulePrint(string reportName)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.txtReportName.Text = reportName;

			LoadPrinters();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSchedulePrint));
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.grpLine = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.txtReportName = new System.Windows.Forms.TextBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpScheduleJob.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(382, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Schedule Print";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 169);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.grpLine);
			this.grpScheduleJob.Controls.Add(this.label1);
			this.grpScheduleJob.Controls.Add(this.txtReportName);
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Location = new System.Drawing.Point(60, 32);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(312, 109);
			this.grpScheduleJob.TabIndex = 0;
			this.grpScheduleJob.TabStop = false;
			// 
			// grpLine
			// 
			this.grpLine.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpLine.Location = new System.Drawing.Point(8, 40);
			this.grpLine.Name = "grpLine";
			this.grpLine.Size = new System.Drawing.Size(296, 7);
			this.grpLine.TabIndex = 2;
			this.grpLine.TabStop = false;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(88, 20);
			this.label1.TabIndex = 0;
			this.label1.Text = "Report Name";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtReportName
			// 
			this.txtReportName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtReportName.Location = new System.Drawing.Point(96, 16);
			this.txtReportName.Name = "txtReportName";
			this.txtReportName.ReadOnly = true;
			this.txtReportName.Size = new System.Drawing.Size(208, 20);
			this.txtReportName.TabIndex = 1;
			this.txtReportName.TabStop = false;
			this.txtReportName.Text = "";
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 80);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(208, 22);
			this.cmbPrinterName.TabIndex = 6;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(8, 80);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(92, 20);
			this.lblPrinterName.TabIndex = 5;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(8, 56);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(88, 20);
			this.lblPrintDate.TabIndex = 3;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 56);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(208, 20);
			this.dtpPrintDate.TabIndex = 4;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(220, 149);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.OKHover);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(300, 149);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.CancelClick);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 109);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 1;
			this.pictureBox1.TabStop = false;
			// 
			// DlgSchedulePrint
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(382, 185);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.grpScheduleJob);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(390, 212);
			this.Name = "DlgSchedulePrint";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Schedule Print";
			this.Controls.SetChildIndex(this.grpScheduleJob, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.grpScheduleJob.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Get PrinterName
		/// </summary>
		public string PrinterName
		{
			get
			{
				if (this.cmbPrinterName.SelectedIndex>-1)
				{
					return this.cmbPrinterName.Text;
				}
				else
				{
					return null;
				}
			}
		}

		/// <summary>
		/// Get PrintDate
		/// </summary>
		public DateTime PrintDate
		{
			get
			{
				return this.dtpPrintDate.Value;
			}
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary> 
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.btnOK.EnabledButton = false;
			this.btnOK.Text = "&OK";
			//
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpPrintDate.Value = currentDate;
			this.dtpPrintDate.MinDate = currentDate;
			//
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
		}

		private void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();

			foreach( string _printerName in BOL.VbecsReport.GetPrinters() )
				cmbPrinterName.Items.Add( _printerName );
		}

		private void PrinterChanged(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this.cmbPrinterName.SelectedIndex>-1);
		}

		private void CancelClick(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void OKHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToProceed().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPrinter().ResString);
			}
		}
	}
}

